import { Link, useLocation } from 'react-router-dom'
import { ScrollText } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper">
      <header className="header">
        <div className="container">
          <div className="header-content">
            <Link to="/" className="logo">
              <ScrollText className="logo-icon" size={26} strokeWidth={1.5} />
              <span className="logo-text">Наследие</span>
            </Link>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои экскурсии
              </Link>
              <Link 
                to="/book" 
                className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout
